' Test for new named colors in 5.07xx

const UP = 128
const DOWN = 129
const ESCAPE = 27
const MAX_DEPTHS = 4

option default integer
option base 1

' Info for the various color depths. 32-bit color (really 24) is only available
' on Gen 2 devices.
dim depths(MAX_DEPTHS) = (8, 12, 16, 32)
dim nbits(MAX_DEPTHS) = (8, 16, 16, 32)

' Get hardware type and firmware version
'open "debug.txt" for output as #1
d$ = MM.DEVICE$
dim float v = MM.INFO(VERSION)
if v < 5.07 then
  print "Sorry, this program requires at least 5.07 firmware"
  end
end if
if instr(d$, "G2") > 0 then
  ndepths = 4
else
  ndepths = 3
end if
dindex = 1
depth = depths(dindex)
mode 1, depth
DrawColors
HandleEvents
end

sub DrawColors
  for i = 1 to 4
    y = (i-1)*150
    for j = 1 to 4
      x = (j-1)*200
      cx = (i-1)*4 + j
      select case cx
        case 1 : c = rgb(black)      : n$ = "black"
        case 2 : c = rgb(blue)       : n$ = "blue"
        case 3 : c = rgb(green)      : n$ = "green"
        case 4 : c = rgb(cyan)       : n$ = "cyan"
        case 5 : c = rgb(red)        : n$ = "red"
        case 6 : c = rgb(magenta)    : n$ = "magenta"
        case 7 : c = rgb(yellow)     : n$ = "yellow"
        case 8 : c = rgb(brown)      : n$ = "brown"
        case 9 : c = rgb(white)      : n$ = "white"
        case 10: c = rgb(orange)     : n$ = "orange"
        case 11: c = rgb(pink)       : n$ = "pink"
        case 12: c = rgb(gold)       : n$ = "gold"
        case 13: c = rgb(salmon)     : n$ = "salmon"
        case 14: c = rgb(beige)      : n$ = "beige"
        case 15: c = rgb(lightgray)  : n$ = "lightgray"
        case 16: c = rgb(gray)       : n$ = "gray"
      end select
      box x, y, 200, 150,, rgb(black), c
      wc = pixel(x+100, y+75)
      text x + 100, y+145, n$, "CB",,,, rgb(black), rgb(white)
      if dindex < 4 then
        text x + 100, y+125, hex$(wc, 8), "CB",,,, rgb(black), rgb(white)
      else 
        text x + 100, y+125, hex$(c, 8), "CB",,,, rgb(black), rgb(white)
      end if
      AnalyzeColor c, wc, r, g, b
      m$ = "R: " + str$(r) + " G: " + str$(g) + " B: " + str$(b)
      text x + 100, y + 105, m$, "CB",,,, rgb(black), rgb(white)
   next j
 next i
 m$ = str$(depth) + "-bit color"
 text 1, 1, m$, "LT"
 text 1, 16, "Use UP/DOWN Arrows to"
 text 1, 31, " change color depth"
 text 1, 46, "Press ESC to quit"
 if dindex = 4 then save image "NewColorsTest"
end sub

sub HandleEvents
  local z$
  local cmd
  do
    z$ = INKEY$
    do
      z$ = INKEY$
    loop until z$ <> ""
    cmd = asc(z$)
    select case cmd
      case UP
        if dindex < ndepths then
          inc dindex
          depth = depths(dindex)
          mode 1, depth
          DrawColors
        end if
      case DOWN
        if dindex > 1 then
          inc dindex, -1
          depth = depths(dindex)
          mode 1, depth
          DrawColors
        end if
      case ESCAPE
        cls
        end
    end select
  loop
end sub

' Extract the RGB components from the expanded color value that we
' get by reading a pixel back from the screen.
sub AnalyzeColor c, wc, r, g, b
  select case dindex
    case 1 to 3
      r = (wc and &HFF0000) >> 16
      g = (wc and &H00FF00) >> 8
      b = wc and &H0000FF
    case 4
      r = (c and &HFF0000) >> 16
      g = (c and &H00FF00) >> 8
      b = c and &H0000FF
  end select
end sub
